import org.uddi4j.client.UDDIProxy;
import org.uddi4j.response.TModelInfo;
import org.uddi4j.response.TModelInfos;
import org.uddi4j.response.TModelList;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.FindQualifier;
import org.uddi4j.util.FindQualifiers;
import org.uddi4j.util.KeyedReference;
import java.util.Vector;

public class UDDIFindTModel2 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
//		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setInquiryURL("http://www-3.ibm.com/services/uddi/inquiryapi");

		Vector cbv = new Vector();
		KeyedReference kr = new KeyedReference("types", "identifier");
	 	kr.setTModelKey("uuid:c1acf26d-9672-4404-9d70-39b756e62ab4");
		cbv.addElement(kr);
		CategoryBag cb = new CategoryBag();
		cb.setKeyedReferenceVector(cbv);

		Vector fqv = new Vector();
		FindQualifier fq;
		fq = new FindQualifier(FindQualifier.sortByNameDesc);
		fqv.add(fq);
		FindQualifiers fqs = new FindQualifiers();
		fqs.setFindQualifierVector(fqv);

		TModelList tl = proxy.find_tModel(null, cb, null, fqs, 0 );

		TModelInfos tis = tl.getTModelInfos();
		if (tis.size() == 0) {
			System.out.println("no tmodel(s) found");
			System.exit(0);
		}

		System.out.println(tis.size()+" tmodel(s) found\n");
		Vector tiv = tis.getTModelInfoVector();
		for (int i = 0; i < tiv.size(); i++) {
			TModelInfo ti = (TModelInfo)tiv.elementAt(i);
			System.out.println(ti.getNameString());
			System.out.println(ti.getTModelKey());
			System.out.println("\n");
		}
	}
}